package com.upyuns.platform.rs.universal.feign;

import com.upyuns.platform.rs.universal.dto.RegionDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author libin
 * @version 1.0
 * @description 区域码 接口
 * @data 2019/7/3 20:00
 */
@FeignClient(value = "rs-universal", contextId = "region")
public interface RegionFeign {

    /**
     * 根据城市名查询
     * @param city
     * @return
     */
    @GetMapping("/sysRegion/region_name")
    RegionDTO getRegionByCityName(@RequestParam(value = "city") String city);
}
