package com.upyuns.platform.rs.datacenter.rest.backstage;

import cn.hutool.core.collection.CollUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpImagePriceBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/bg/imagePrice")
public class BgRscpImagePriceController extends BaseController<RscpImagePriceBiz, RscpImagePrice> {

    @Override
    public ObjectRestResponse<PageDataVO<RscpImagePrice>> pages(Map<String, Object> params) {
        //查询列表数据
        Query query = new Query(params);
        return ObjectRestResponse.succ(baseBiz.selectByQueryLogicPage(query));
    }
}