package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.OrderItemBiz;
import com.upyuns.platform.rs.website.biz.ServiceCapabilityBiz;
import com.upyuns.platform.rs.website.dto.ServiceCapabilityDTO;
import com.upyuns.platform.rs.website.dto.TModelDTO;
import com.upyuns.platform.rs.website.entity.OrderItem;
import com.upyuns.platform.rs.website.entity.ServiceCapability;
import com.upyuns.platform.rs.website.entity.TModel;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("serviceCapability")
public class ServiceCapabilityController extends BaseController<ServiceCapabilityBiz, OrderItem> {


    @PostMapping(value = "/app/unauth/addUpdate")
    @IgnoreUserToken
    public ObjectRestResponse addUpdate(@RequestBody ServiceCapability serviceCapability) {
        return baseBiz.addObj(serviceCapability);
    }


    @PostMapping(value = "/app/unauth/getList")
    @IgnoreUserToken
    public ObjectRestResponse getList(@RequestBody ServiceCapabilityDTO serviceCapabilityDTO) {
        return baseBiz.getList(serviceCapabilityDTO);
    }


    @GetMapping(value = "/app/unauth/detail")
    @IgnoreUserToken
    public ObjectRestResponse detail(Integer id) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }

    @GetMapping(value = "/app/unauth")
    @IgnoreUserToken
    public ObjectRestResponse get() {
        return baseBiz.get();
    }


}
