package com.upyuns.platform.rs.website.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 *
 * @TableName api_custom_params
 */
@Table(name="api_custom_params")
@Data
public class ApiCustomParams implements Serializable {
    /**
     * 主键自增ID
     */
    @Id
    private Integer id;

    /**
     * api_doc主键ID
     */
    @Column(name = "doc_id")
    private Long docId;

    /**
     * 节点ID
     */
    @Column(name = "node_id")
    private Long nodeId;

    /**
     * 请求方式：get、head、post、put、patch、delete、options、trace
     */
    private String method;

    /**
     * 接口url
     */
    @Column(name = "api_url")
    private String apiUrl;

    /**
     * form参数
     */
    @Column(name = "form_data")
    private String formData;

    /**
     * body参数
     */
    @Column(name = "body_data")
    private String bodyData;

    /**
     * header参数
     */
    @Column(name = "header_data")
    private String headerData;

    /**
     * cookie参数
     */
    @Column(name = "cookie_data")
    private String cookieData;

    /**
     * 状态：1.上架 2.下架
     */
    private Byte status;

    /**
     * 是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
    private Byte isDel;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(name = "create_user")
    private Long createUser;

    /**
     * 更新时间
     */
    @Column(name = "last_update_time")
    private Date lastUpdateTime;

    /**
     * 更新人
     */
    @Column(name = "last_update_user")
    private Long lastUpdateUser;

    private static final long serialVersionUID = 1L;
}
