package com.upyuns.platform.rs.website.dto;

import com.github.wxiaoqi.security.common.vo.PageParam;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 模型
 * @TableName t_model
 */

@Data
public class TModelDTO extends PageParam implements Serializable {


    /**
     * 模型中文
     */
    private String modelCn;

    /**
     * 模型英文
     */
    private String modelEn;

    /**
     * 发布单位
     */
    private String releasedBy;

    /**
     * 模型分类id
     */
    private String modelTypeIds;

    /**
     * 排序
     */
    private Integer orderBy;

    /**
     * 版本号
     */
    private Integer modelVersion;

    /**
     * 软件框架
     */
    private String softwareFramework;

    /**
     * 硬件类型
     */
    private String hardwareType;

    /**
     * 审核状态：1.待审核 2.通过 3.拒绝
     */
    private Byte examineStatus;

    /**
     * 状态：1.上架 2.下架
     */
    private Byte status;

}
