package com.upyuns.platform.rs.datacenter.rest;


import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataFrequencyBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataFrequency;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataNewest;
import com.upyuns.platform.rs.datacenter.pojo.RscpImageDataNewestDTO;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@RestController
@RequestMapping("/web/DataFrequency")
public class RscpImageDataFrequencyController extends BaseController<RscpImageDataFrequencyBiz, RscpImageDataFrequency> {

    @ApiModelProperty("原始遥感影像热搜榜")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/mapAll",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpImageDataFrequency>> getPageList(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpImageDataFrequency.class);
        Example.Criteria criteria = example.createCriteria();
        example.orderBy("frequency").desc();
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }

}
