package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ImageInfoRelationBiz;
import com.upyuns.platform.rs.website.dto.ImageInfoRelationDto;
import com.upyuns.platform.rs.website.entity.ImageInfoRelation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("imageInfoRelation")
public class ImageInfoRelationController extends BaseController<ImageInfoRelationBiz,ImageInfoRelation> {

	@GetMapping(value = "getAll")
	public ObjectRestResponse getAll(ImageInfoRelationDto imageInfoRelationDto) {
		return baseBiz.getAll(imageInfoRelationDto);
	}

	@GetMapping(value = "getAllImageRelation")
	public ObjectRestResponse getAllImageRelation(Integer relationId, Integer type) {
		return ObjectRestResponse.succ(baseBiz.getAllImageRelation(relationId, type));
	}

	@GetMapping(value = "getOneByWidth")
	public ObjectRestResponse getOneByWidth(Integer relationId, Integer type, String fileWidth) {
		return ObjectRestResponse.succ(baseBiz.getOneByWidth(relationId, type, fileWidth));
	}

}