package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.BannerBiz;
import com.upyuns.platform.rs.website.dto.BannerDto;
import com.upyuns.platform.rs.website.entity.Banner;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("banner")
public class BannerController extends BaseController<BannerBiz, Banner> {

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody Banner banner) {
		return baseBiz.add(banner);
	}

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(BannerDto bannerDto) {
		return baseBiz.selectList(bannerDto);
	}

	@GetMapping(value = "/app/unauth/getAll")
	@IgnoreUserToken
	public ObjectRestResponse getAll() {
		return baseBiz.getAll(1);
	}
}