package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.ImageInformationDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.ImageInformation;
import com.upyuns.platform.rs.website.mapper.ImageInformationMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 影像信息介绍信息表
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-28 14:15:32
 */
@Service
public class ImageInformationBiz extends BaseBiz<ImageInformationMapper, ImageInformation> {

	/**
	 * 新增或者编辑图像信息
	 *
	 * @param imageInformation
	 * @return
	 */
	public ObjectRestResponse addUpdate(ImageInformation imageInformation) {
		if (imageInformation == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (imageInformation.getId() == null) {
			insertSelectiveRe(imageInformation);
		} else {
			ImageInformation old = selectById(imageInformation.getId());
			if (old == null) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			} else {
				BeanUtil.copyProperties(imageInformation, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
				updateSelectiveByIdRe(old);
			}
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 分页查询图像信息
	 *
	 * @param imageInformationDto
	 * @return
	 */
	public ObjectRestResponse selectList(ImageInformationDto imageInformationDto) {
		Example example = new Example(ImageInformation.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0);
		if (StringUtils.isNotBlank(imageInformationDto.getName())) {
			criteria.andLike("name", "%" + imageInformationDto.getName() + "%");
		}
		if (imageInformationDto.getStatus() != null) {
			criteria.andEqualTo("status", imageInformationDto.getStatus());
		}
		if (imageInformationDto.getIndexShow() != null) {
			criteria.andEqualTo("indexShow", imageInformationDto.getIndexShow());
		}
		example.orderBy("updTime").desc();
		Query query = new Query(imageInformationDto);
		PageDataVO<ImageInformation> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}

	/**
	 * 获取所有影像信息
	 *
	 * @return
	 */
	public List<ImageInformation> getAll() {
		Example example = new Example(ImageInformation.class);
		example.createCriteria().andEqualTo("isDel", 0).andEqualTo("status", 1);
		example.orderBy("rank");
		return mapper.selectByExample(example);
	}
}