package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-28 14:15:32
 */
@Data
@Table(name = "user_address")
public class UserAddress implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 订单收获地址id
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("订单收获地址id")
	private Integer id;

	/**
	 * 收获人姓名
	 */
	@Column(name = "consignee_name")
	@ApiModelProperty(value = "收获人姓名")
	private String consigneeName;

	/**
	 * 收件人电话
	 */
	@Column(name = "consignee_phone")
	@ApiModelProperty(value = "收件人电话")
	private String consigneePhone;

	/**
	 * 收货人详细地址，不包含省市区乡镇
	 */
	@Column(name = "consignee_address")
	@ApiModelProperty(value = "收货人详细地址，不包含省市区乡镇")
	private String consigneeAddress;

	/**
	 * 省份
	 */
	@Column(name = "province")
	@ApiModelProperty(value = "省份")
	private String province;

	/**
	 * 市
	 */
	@Column(name = "city")
	@ApiModelProperty(value = "市")
	private String city;

	/**
	 * 区县
	 */
	@Column(name = "district")
	@ApiModelProperty(value = "区县")
	private String district;

	/**
	 * 乡镇/街道
	 */
	@Column(name = "town")
	@ApiModelProperty(value = "乡镇/街道")
	private String town;

	/**
	 *
	 */
	@Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间")
	private Date crtTime;

	/**
	 *
	 */
	@Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间")
	private Date updTime;


	@Column(name = "user_id")
	@ApiModelProperty(value = "用户ID")
	private Long userId;

	/**
	 * 是否删除： 0、否，1、是
	 */
	private Integer isDel;

	/**
	 * 是否是默认值： 0、否，1、是
	 */
	private Integer isDefault;

}
