package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 购物车
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Data
@Table(name = "shopping_cart_info")
public class ShoppingCartInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Long cartId;
	
	    /**
     *  订单名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "订单名称")
    private String name;
	
	    /**
     *  详情id
     */
    @Column(name = "detail_id")
	@ApiModelProperty(value = "详情id")
    private Integer detailId;
	
	    /**
     *  详情json信息
     */
    @Column(name = "detail_json")
	@ApiModelProperty(value = "详情json信息")
    private String detailJson;
	
	    /**
     *  单价
     */
    @Column(name = "price")
	@ApiModelProperty(value = "单价")
    private BigDecimal price;
	
	    /**
     *  数量
     */
    @Column(name = "number")
	@ApiModelProperty(value = "数量")
    private Integer number;
	
	    /**
     *  订单图片
     */
    @Column(name = "item_pic")
	@ApiModelProperty(value = "订单图片")
    private String itemPic;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  用户手机号
     */
    @Column(name = "phone")
	@ApiModelProperty(value = "用户手机号")
    private String phone;
	
	    /**
     *  用户昵称
     */
    @Column(name = "nickname")
	@ApiModelProperty(value = "用户昵称")
    private String nickname;
	
	    /**
     *  用户真实姓名
     */
    @Column(name = "real_name")
	@ApiModelProperty(value = "用户真实姓名")
    private String realName;
	
	    /**
     *  头像
     */
    @Column(name = "head_img")
	@ApiModelProperty(value = "头像")
    private String headImg;
	
	    /**
     *  下单时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "下单时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	
	    /**
     *  1、标准数据，2、影像图库，3、行业应用信息
     */
    @Column(name = "type")
	@ApiModelProperty(value = "1、标准数据，2、影像图库，3、行业应用信息")
    private Integer type;
	
	    /**
     *  是否删除: 0、否，1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除: 0、否，1、是")
    private Integer isDel;
	
	    /**
     *  文件路径
     */
    @Column(name = "file_path")
	@ApiModelProperty(value = "文件路径")
    private String filePath;

	/**
	 *
	 */
	@Column(name = "total_amount")
	@ApiModelProperty(value = "")
	private BigDecimal totalAmount;


	public static OrderItem convertToOrderItem(ShoppingCartInfo shoppingCartInfo) {
		OrderItem orderItem = new OrderItem();
		orderItem.setDetailId(shoppingCartInfo.getDetailId());
		orderItem.setDetailJson(shoppingCartInfo.getDetailJson());
		orderItem.setFilePath(shoppingCartInfo.getFilePath());
		orderItem.setItemPic(shoppingCartInfo.getItemPic());
		orderItem.setName(shoppingCartInfo.getName());
		orderItem.setNumber(shoppingCartInfo.getNumber());
		orderItem.setPrice(shoppingCartInfo.getPrice());
		orderItem.setTotalAmount(shoppingCartInfo.getTotalAmount());
		orderItem.setType(shoppingCartInfo.getType());
		return orderItem;
	}
}
