package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 影像图库
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-28 14:15:32
 */
@Data
@Table(name = "image_img_storage")
public class ImageImgStorage implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  类型 1--影像美图 2--专题图 3--遥感成果图
     */
    @Column(name = "type")
	@ApiModelProperty(value = "类型 1--影像美图 2--专题图 3--遥感成果图")
    private Integer type;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  介绍
     */
    @Column(name = "intro")
	@ApiModelProperty(value = "介绍")
    private String intro;
	
	    /**
     *  封面图
     */
    @Column(name = "cover_img")
	@ApiModelProperty(value = "封面图")
    private String coverImg;
	
	    /**
     *  详情图
     */
    @Column(name = "detail_img")
	@ApiModelProperty(value = "详情图")
    private String detailImg;
	
	    /**
     *  产品参数json
     */
    @Column(name = "param_json")
	@ApiModelProperty(value = "产品参数json")
    private String paramJson;
	
	    /**
     *  内容-富文本
     */
    @Column(name = "content")
	@ApiModelProperty(value = "内容-富文本")
    private String content;
	
	    /**
     *  是否允许定制：0、否， 1、是
     */
    @Column(name = "allow_custom")
	@ApiModelProperty(value = "是否允许定制：0、否， 1、是")
    private Integer allowCustom;
	
	    /**
     *  是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否， 1、是")
    private Integer isDel;
	
	    /**
     *  排序
     */
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	    /**
     *  是否启用：1、启用，2、禁用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "是否启用：1、启用，2、禁用")
    private Integer status;
	
	    /**
     *  关联ids
     */
    @Column(name = "related_ids")
	@ApiModelProperty(value = "关联ids")
    private String relatedIds;


	private Date crtTime;

	private Date updTime;

	//源图像信息
	@Transient
	List<ImageInfoRelation> imageInfoRelationList;

	//相似图像
	@Transient
	List<ImageInfoRelation> similarImageList;
}
