package com.upyuns.platform.rs.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.upyuns.platform.rs.universal.biz.OrderRefundBiz;
import com.upyuns.platform.rs.universal.entity.OrderRefund;
import com.upyuns.platform.rs.universal.vo.OrderRefundVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("refund")
public class OrderRefundController extends BaseController<OrderRefundBiz,OrderRefund> {

    @RequestMapping(value = "/app/pay/refund", method = RequestMethod.POST) //匹配的是href中的download请求
    public JSONObject refund(@RequestBody OrderRefundVo orderRefundVo) {
        try {
            return baseBiz.refund(orderRefundVo);
        }catch (Exception e){
            e.getMessage();
            return JsonResultUtil.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
        }
    }

    @GetMapping(value = "/app/unauth/tradRefund")
    @ApiOperation("预授权转支付接口")
    public ObjectRestResponse tradRefund(String tradNo, Integer refundAmount, String refundReason, String outRequestNo) {
        return baseBiz.tradeRefund(tradNo, refundAmount, refundReason, outRequestNo);
    }

}