package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.*;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import lombok.RequiredArgsConstructor;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/24 15:11
 */
@ConditionalOnProperty(prefix = "data.clean", name = "enable", havingValue = "true")
@RequiredArgsConstructor(onConstructor = @__({@Autowired}))
@RestController
@RequestMapping("/app/unauth/user_data")
public class DataController {

    private final AppUserLoginBiz appUserLoginBiz;

    private final AppUserDetailBiz appUserDetailBiz;

    private final AppUserRelationBiz appUserRelationBiz;

    private final AppUserSellingWaterBiz appUserSellingWaterBiz;

    private final MyWalletCathBiz walletCathBiz;

    private final BaseUserMemberBiz userMemberBiz;


    @GetMapping("/clearwithphone")
    public ObjectRestResponse<Void> clearData(@RequestParam("phones") List<String> phons) {

        Map<String, Integer> phoneAndUserIdMapByPhones = appUserLoginBiz.findPhoneAndUserIdMapByPhones(phons);
        if (Objects.nonNull(phoneAndUserIdMapByPhones)) {
            Collection<Integer> userIds = phoneAndUserIdMapByPhones.values();
            //1.删除登录表信息
            appUserLoginBiz.deleteByPhones(phons);
            //2.删除用户详情信息
            appUserDetailBiz.deleteByUserIds(userIds);
            //3.删除用户关系表信息
            appUserRelationBiz.deleteByMemberIds(userIds);
            //5.删除用户提现记录
            walletCathBiz.deleteByUserIds(userIds);
            //6.删除会员信息
            userMemberBiz.deleteByUserIds(userIds);
            //7.删除佣金数据
            appUserSellingWaterBiz.deleteByMemberIds(userIds);
        }
        return ObjectRestResponse.succ();
    }

    @GetMapping("/clear_relation_withphone")
    public ObjectRestResponse<Void> clearRelationphone(@RequestParam("phones") List<String> phons) {

        Map<String, Integer> phoneAndUserIdMapByPhones = appUserLoginBiz.findPhoneAndUserIdMapByPhones(phons);
        if (Objects.nonNull(phoneAndUserIdMapByPhones)) {
            Collection<Integer> userIds = phoneAndUserIdMapByPhones.values();
            appUserRelationBiz.deleteByMemberIds(userIds);
            appUserSellingWaterBiz.deleteByMemberIds(userIds);

        }
        return ObjectRestResponse.succ();
    }
}