package com.upyuns.platform.rs.gtdata;

import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;

/**
 * 用于多gt-data路径转化的相关工具
 * @author wugq
 *
 */
public class GtPathUtil {
	
	private final String[] paths;
	private String displayPath;
	
	/**
	 * 对外隐藏默认构造函数
	 */
	private GtPathUtil(){
		paths = null;
	}
	
	public GtPathUtil(String path){
		while(path.endsWith("/") && path.length()>1){
			path = path.substring(0, path.length()-1);
		}
		paths = StringUtils.splitByWholeSeparator(path, "/");
	}
	public GtPathUtil(String path,String filename){
		path = path +"/"+filename;
		while(path.endsWith("/") && path.length()>1){
			path = path.substring(0, path.length()-1);
		}
		paths = StringUtils.splitByWholeSeparator(path, "/");
	}
	
	
	public String getFileName(){
		String name = paths[paths.length-1];
		return name;
	}	
	
	public String getPath() {
		if(displayPath == null){
			displayPath = "/" + StringUtils.join(paths, "/");
		}
		return displayPath;
	}
	
	public String getParentPath() {
		String path = "";
		if (paths.length <= 1)
			path =  "/";
		else{
			path = getPath();
			path = path.substring(0, path.lastIndexOf("/"));
		}		
		return path;
	}

	/**
	 * @param args
	 * @throws UnsupportedEncodingException 
	 */
	public static void main(String[] args){
		// TODO Auto-generated method stub
		for(String str : StringUtils.splitByWholeSeparator("//sdasda///dsadas///aaaa", "/")){
			if(str.isEmpty()){
				System.out.println("error");
			}
//			System.out.println(str);
		}
		System.out.println(new GtPathUtil("//sdasda///dsadas//aaaa//dddd///").getFileName());
		System.out.println(new GtPathUtil("//sdasda///dsadas//aaaa//dddd///").getParentPath());
		System.out.println(new GtPathUtil("//sdasda///dsadas//aaaa//dddd///").getPath());
	}

}
