package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.CommonInfoDto;
import com.upyuns.platform.rs.website.entity.CommonInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.CompanyInfo;
import com.upyuns.platform.rs.website.mapper.CompanyInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 
 *
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2020-12-11 10:25:29
 */
@Service
public class CompanyInfoBiz extends BaseBiz<CompanyInfoMapper,CompanyInfo> {

	/**
	 * 新增公司信息
	 * @param companyInfo
	 * @return
	 */
	public ObjectRestResponse addUpdate(CompanyInfo companyInfo) {
		if (companyInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (companyInfo.getId() != null) {
			CompanyInfo old = selectById(companyInfo.getId());
			if (old == null || old.getIsDel() == 1) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			}
			BeanUtil.copyProperties(companyInfo, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		} else {
			insertSelectiveRe(companyInfo);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 分页查询公司信息
	 * @param commonInfoDto
	 * @return
	 */
	public ObjectRestResponse getAll(CommonInfoDto commonInfoDto) {
		Example example = new Example(CompanyInfo.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0);
		if (StringUtils.isNotBlank(commonInfoDto.getName())) {
			criteria.andLike("name", "%" + commonInfoDto.getName() + "%");
		}
		Query query = new Query(commonInfoDto);
		PageDataVO<CompanyInfo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}


	public ObjectRestResponse getIndexShow() {
		Example example = new Example(CompanyInfo.class);
		example.createCriteria().andEqualTo("isDel", 0).andEqualTo("indexShow", 1);
		example.orderBy("updTime").desc();
		List<CompanyInfo> list = mapper.selectByExample(example);
		if (list != null && list.size() > 0) {
			return ObjectRestResponse.succ(list.get(0));
		}
		return ObjectRestResponse.succ(new CompanyInfo());
	}
}