package com.upyuns.platform.rs.website.vo;

import com.upyuns.platform.rs.website.entity.*;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName : ConfirmOrderInfoVo
 * @Description : 确认订单
 * @Author : jiaoruizhen
 * @Date: 2020-12-16 14:57
 */
@Data
public class ConfirmOrderInfoVo {

	/**
	 * 配送方式:1、线上配送，2、快递配送
	 */
	private Integer sendType;

	/**
	 * 用户地址列表
	 */
	private List<UserAddress> userAddressList;

	/**
	 * 用户发票列表
	 */
	private List<UserInvoice> userInvoiceList;

	/**
	 * 订单商品数量
	 */
	private Integer number;

	/**
	 * 总金额
	 */
	private BigDecimal totalAmount;

	/**
	 * 实付金额
	 */
	private BigDecimal actAmount;

	/**
	 * 运费
	 */
	private BigDecimal fee;

	private List<ItemInfoVo> itemInfoVoList;

}
