package com.upyuns.platform.rs.website.type;

/**
 * @ClassName : OrderStatusEnum
 * @Description : 订单状态
 * @Author : jiaoruizhen
 * 订单状态：0、定制订单无价格  1--创建订单，2--待付款，3--已支付，4--已发货, 5--已收货, 6、已完成 -1、删除，-2、取消, -3 退款
 * @Date: 2020-12-12 16:50
 */
public enum OrderStatusEnum {
	ORDER_NO_PRICE(0, "定制订单无价格"),
	ORDER_CREATED(1, "创建订单"),
	ORDER_UNPAID(2, "待付款"),
	ORDER_PAID(3, "已支付"),
	ORDER_SEND(4, "已发货"),
	ORDER_RECEIVED(5, "已收货"),
	ORDER_COMPLETE(6, "已完成"),
	ORDER_DELETE(-1, "删除"),
	ORDER_CANCEL(-2, "取消"),
	ORDER_REFUND(-3, "退款");
	private Integer type;
	private String msg;

	OrderStatusEnum(Integer type, String msg) {
		this.type = type;
		this.msg = msg;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}


	public static <T extends OrderStatusEnum> String getType(Integer code, Class<T> t) {
		for (T item : t.getEnumConstants()) {
			if (item.getType().equals(code)) {
				return item.getMsg();
			}
		}
		return "";
	}

	public static OrderStatusEnum getByCode(Integer code) {
		for (OrderStatusEnum v : values()) {
			if (v.getType() == code) {
				return v;
			}
		}
		return null;
	}

	public static String getProductStatusEnum(Integer code) {
		return getType(code, OrderStatusEnum.class);
	}

}
