package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 成果数据日志
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-09-14 13:29:08
 */
@Data
@Table(name = "gaindata_log")
public class GaindataLog implements Serializable {
	private static final long serialVersionUID = 1L;
	//1001--录入；
	//2211--生产线镶嵌；2212--生产线温度反演；2213--生产线植被覆盖度；2214--生产线植被识别；2215--水体识别；2216--风险等级；2217--病虫害监测
	//2221--生产线切片；
	//2311--AI系统船舶识别；
	public static final String TYPE_1001 = "1001";
	public static final String TYPE_2211 = "2211";
	public static final String TYPE_2212 = "2212";
	public static final String TYPE_2213 = "2213";
	public static final String TYPE_2214 = "2214";
	public static final String TYPE_2215 = "2215";
	public static final String TYPE_2216 = "2216";
	public static final String TYPE_2217 = "2217";

	public static final String TYPE_2218 = "2218";
	public static final String TYPE_2221 = "2221";
	public static final String TYPE_2311 = "2311";
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  操作类型 1001--录入；2211--生产线镶嵌；2212--生产线温度反演；2213--生产线植被覆盖度；2214--生产线植被识别；2215--生产线水体识别；2216--生产线风险等级；2217--生产线病虫害监测
     */
    @Column(name = "type")
	@ApiModelProperty(value = "操作类型 1001--录入；2211--生产线镶嵌；2212--生产线温度反演；2213--生产线植被覆盖度；2214--生产线植被识别；2215--生产线水体识别；2216--生产线风险等级；2217--生产线病虫害监测")
    private String type;
	
	    /**
     *  数据来源 1--门户；2--生产线；3--AI系统
     */
    @Column(name = "source")
	@ApiModelProperty(value = "数据来源 1--门户；2--生产线；3--AI系统")
    private Integer source;
	
	    /**
     *  功能模块 0--默认；
     */
    @Column(name = "source_module")
	@ApiModelProperty(value = "功能模块 0--默认；")
    private String sourceModule;
	
	    /**
     *  成果数据id 1--已删除；0--未删除
     */
    @Column(name = "gain_id")
	@ApiModelProperty(value = "成果数据id 1--已删除；0--未删除")
    private Integer gainId;
	
	    /**
     *  是否删除 1--已删除；0--未删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除 1--已删除；0--未删除")
    private Integer isDel;
	
	    /**
     *  属性信息
     */
    @Column(name = "detail_json")
	@ApiModelProperty(value = "属性信息")
    private String detailJson;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  创建人
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建人")
    private String crtUser;
	
	    /**
     *  更新人
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新人")
    private String updUser;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  用户名称
     */
    @Column(name = "username")
	@ApiModelProperty(value = "用户名称")
    private String username;
	
	    /**
     *  1--已提交;
     */
    @Column(name = "status")
	@ApiModelProperty(value = "1--已提交;")
    private Integer status;
	
	    /**
     *  备注描述
     */
    @Column(name = "remark")
	@ApiModelProperty(value = "备注描述")
    private String remark;


	/**
	 *  内容
	 */
	@Column(name = "content")
	@ApiModelProperty(value = "内容")
	private String content;

	/**
	 *  日志时间
	 */
	@Column(name = "log_time")
	@ApiModelProperty(value = "日志时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date logTime;
}
