package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.collection.CollUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.AssertUtils;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpMosaicimageBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpStorageJsonBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import com.upyuns.platform.rs.datacenter.entity.RscpMonitorimage;
import com.upyuns.platform.rs.datacenter.entity.RscpMosaicimage;
import com.upyuns.platform.rs.datacenter.entity.RscpStorageJson;
import com.upyuns.platform.rs.datacenter.pojo.RscpImageDataNewestDTO;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/web/rscpMosaicimage")
public class RscpMosaicimageController extends BaseController<RscpMosaicimageBiz, RscpMosaicimage> {

    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse unauthQuery() {

        List<RscpMosaicimage> list = baseBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpMosaicimage::getStatus, 2);
            w.andEqualTo(RscpMosaicimage::getIsDel, 0);
            return w;
        }, "hot DESC, start_time asc");
        return ObjectRestResponse.succ(list);
    }

    @ApiModelProperty("遥感影像最新时间分页")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/mapAll",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpMosaicimage>> getPageList(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpMosaicimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status",2);
        criteria.andEqualTo("isDel",0);
        example.setOrderByClause("start_time DESC");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }




    @ApiModelProperty("遥感影像热度排序")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/hotall",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpMosaicimage>> all(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpMosaicimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status",2);
        criteria.andEqualTo("isDel",0);
        example.setOrderByClause("hot DESC");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }
}