package com.upyuns.platform.rs.datacenter.vo;

import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class ImageInputVO {

    //左上角经度
    private BigDecimal leftTopLon;
    //左上角维度
    private BigDecimal leftTopLat;

    //左下角经度
    private BigDecimal leftBottomLon;
    //左下角维度
    private BigDecimal leftBottomLat;

    //右下角经度
    private BigDecimal rightBottomLon;
    //右下角维度
    private BigDecimal rightBottomLat;

    //右上角经度
    private BigDecimal rightTopLon;
    //右上角维度
    private BigDecimal rightTopLat;

    //中心点经纬度
    private BigDecimal imageCenterPointLat;
    private BigDecimal imageCenterPointLon;

    //数据名称
    private String name;

    //缩略图存储路径
    private String thumbnailPath;
    //影像存储地址目录
    private String imageFilePath;
    //文件名称
    private List<String> files;



    //光谱
    private String imageSpectrumType;
    //光谱名称
    private String imageSpectrumTypeDisplay;
    //卫星类型
    private String imageSatelliteType;
    //卫星名称
    private String imageSatelliteTypeDisplay;
    //传感器类型
    private String imageSensorType;
    //传感器id
    private String imageSensorId;
    //景id
    private String imageSceneId;

    //拍摄时间
    private String imageTakeTime;
    //影像开始时间
    private String imageStartTime;
    //影像结束时间
    private String imageEndTime;
    //影像中间时间
    private String imageCenterTime;
    //产品时间
    private String imageProductTime;

    //投影
    private String imageProjection;


    //云量
    private BigDecimal imageCloudage;



    //产品格式 GEOTIFF 、 TIFF
    private String imageProductFormat;

    //sat行号
    private String imageSatPath;
    //sat列号
    private String imageSatRow;

    //分辨率数组
    private BigDecimal[] imageResolution;
    //影像宽度
    private Integer imageWidthInPixels;
    //影像高度
    private String imageHeightInPixels;
    //卫星平台平均俯仰角
    private String imagePitchSatellitessAngle;
    //太阳方位角
    private String imageSolarAzimuth;
    //太阳高度角
    private String imageSolarZenith;
    //卫星方向角
    private String imageSatelliteAzimuth;
    //卫星高度角
    private String imageSatelliteZenith;
    //卫星平台平均偏航角
    private String imageYawSatelliteAngle;

    //供应商
    private String supplier;

    //几何范围
    String range;

    Long logId;

    public void clearBracket(){
        if(StrUtil.isNotBlank(this.getImageSpectrumType())) {
            this.setImageSpectrumType(this.getImageSpectrumType()
                    .replace("{", "").replace("}", ""));
        }
        if(StrUtil.isNotBlank(this.getImageSpectrumTypeDisplay())) {
            this.setImageSpectrumTypeDisplay(this.getImageSpectrumTypeDisplay()
                    .replace("{", "").replace("}", ""));
        }
    }
}
