package com.upyuns.platform.rs.datacenter.pojo.imagedata;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class QueryDTO {
    public static final int TYPE_AREA = 1;
    public static final int TYPE_GEOM = 2;
    public static final int TYPE_SHP = 3;
    String shpKey;
    Integer type;
    String startDate;
    String endDate;
    BigDecimal resolution;
    String startDateTime;
    String endDateTime;
    String geom;
    List<String> geoms;
    String areaNo;
    String provinceNo;
    List<SatelliteDTO> saSensor;
    BigDecimal cloud;

    public void setStartDate(String startDate) {
        this.startDate = startDate;
        if(StrUtil.isNotBlank(startDate)) {
            this.startDateTime = DateUtil.beginOfDay(DateUtil.parseDate(startDate)).toString();
        }
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
        if(StrUtil.isNotBlank(endDate)) {
            this.endDateTime = DateUtil.endOfDay(DateUtil.parseDate(endDate)).toString();
        }
    }

    public void setAreaNo(String areaNo) {
        this.areaNo = areaNo;
        if(StrUtil.isNotBlank(areaNo)) {
            if(!areaNo.substring(2, 6).equals("0000")){
                provinceNo = areaNo.substring(0, 2)+ "0000";
            }
        }
    }

    @Data
    static public class SatelliteDTO {
        String satellite;
        List<String> sensors = CollUtil.newArrayList();
    }
}