package com.upyuns.platform.rs.datacenter.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import tk.mybatis.mapper.annotation.ColumnType;
import tk.mybatis.mapper.annotation.KeySql;

import javax.persistence.*;
import java.math.BigDecimal;
import java.sql.Timestamp;

@Data
@Table(name = "rscp_image_data_total")
@ApiModel(description = "")
public class RscpImageDataTotal implements java.io.Serializable {
    /** 版本号 */
    private static final long serialVersionUID = -5913683428401029013L;

    /* This code was generated by TableGo tools, mark 1 begin. */

    /** 标识id */
    @Id
    @KeySql(useGeneratedKeys = true)
    @Column(name = "id",insertable = false)
    @ApiModelProperty(value = "标识id")
    private Long id;

    /** 编号 */
    @ApiModelProperty(value = "编号")
    private String dataNo;

    /** 数据类型id */
    @ApiModelProperty(value = "数据类型id")
    private String categoryId;

    /** 名称 */
    @ApiModelProperty(value = "名称")
    private String name;

    /** 数据范围数据 */
    @ApiModelProperty(value = "数据范围数据")
    private String range;

    /** 缩略图存储路径 */
    @ApiModelProperty(value = "缩略图存储路径")
    private String thumbnailPath;

    /** 显示名称 */
    @ApiModelProperty(value = "显示名称")
    private String displayName;

    /** 分辨率[数组] */
    @ApiModelProperty(value = "分辨率[数组]")
    @ColumnType(typeHandler = com.upyuns.platform.rs.datacenter.mybatis.ArrayTypeHandler.class)
    private BigDecimal[] imageResolution;

    /** 光谱 */
    @ApiModelProperty(value = "光谱")
    @ColumnType(typeHandler = com.upyuns.platform.rs.datacenter.mybatis.ArrayTypeHandler.class)
    private String[] imageSpectrumType;

    /** 光谱名称 */
    @ApiModelProperty(value = "光谱名称")
    @ColumnType(typeHandler = com.upyuns.platform.rs.datacenter.mybatis.ArrayTypeHandler.class)
    private String[] imageSpectrumTypeDisplay;

    /** 行列号 */
    @ApiModelProperty(value = "行列号")
    private String imageRowCol;

    /** 行号 */
    @ApiModelProperty(value = "行号")
    private String imageRow;

    /** 列号列号 */
    @ApiModelProperty(value = "列号列号")
    private String imageCol;

    /** 产品类型 */
    @ApiModelProperty(value = "产品类型")
    private String imageProductType;

    /** 产品类型名称 */
    @ApiModelProperty(value = "产品类型名称")
    private String imageProductTypeDisplay;

    /** 影像存储地址目录 */
    @ApiModelProperty(value = "影像存储地址目录")
    private String imageFilePath;

    /** 中心点 */
    @ApiModelProperty(value = "中心点")
    private String imageCenterPoint;

    /** 覆盖地区省 */
    @ApiModelProperty(value = "覆盖地区省")
    private String imageProvince;

    /** 覆盖大区市 */
    @ApiModelProperty(value = "覆盖大区市")
    private String imageCity;

    /** 面积 */
    @ApiModelProperty(value = "面积")
    private String imageArea;

    /** 投影 */
    @ApiModelProperty(value = "投影")
    private String imageProjection;

    /** 卫星 */
    @ApiModelProperty(value = "卫星")
    private String imageSatelliteType;

    /** 卫星名称 */
    @ApiModelProperty(value = "卫星名称")
    private String imageSatelliteTypeDisplay;

    /** 拍摄时间 */
    @ApiModelProperty(value = "拍摄时间")
    private String imageTakeTime;

    /** 云量 */
    @ApiModelProperty(value = "云量")
    private BigDecimal imageCloudage;

    /** 处理级别 */
    @ApiModelProperty(value = "处理级别")
    private String imageProductLevel;

    /** 观测类型 */
    @ApiModelProperty(value = "观测类型")
    private String imageObservation;

    /** 传感器类型 */
    @ApiModelProperty(value = "传感器类型")
    private String imageSensorType;

    /** 销售价格 */
    @ApiModelProperty(value = "销售价格")
    private BigDecimal sellPrice;

    /** 销售状态 */
    @ApiModelProperty(value = "销售状态")
    private Integer isSell;

    /** 删除 0未删除 1已删除 */
    @ApiModelProperty(value = "删除 0未删除 1已删除")
    private Integer isDel;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String remark;

    /** 包含那几个文件名称[数组] */
    @ApiModelProperty(value = "包含那几个文件名称[数组]")
    @ColumnType(typeHandler = com.upyuns.platform.rs.datacenter.mybatis.ArrayTypeHandler.class)
    private String[] files;

    /** wms服务地址 */
    @ApiModelProperty(value = "wms服务地址")
    private String imageWmsPath;

    /** 数据保存的外地址 */
    @ApiModelProperty(value = "数据保存的外地址")
    private String imageOutPath;

    /** 是否存在数据,0不存在 1已存在 */
    @ApiModelProperty(value = "是否存在数据,0不存在 1已存在")
    private Integer imageIsSave;

    /** 创建时间 */
    @ApiModelProperty(value = "创建时间")
    private Timestamp createDt;

    /** imageSensorId */
    @ApiModelProperty(value = "")
    private String imageSensorId;

    /** imageProductType1 */
    @ApiModelProperty(value = "")
    private String imageProductType1;

    /** imageSceneId */
    @ApiModelProperty(value = "")
    private String imageSceneId;

    /** imageProductId */
    @ApiModelProperty(value = "")
    private String imageProductId;

    /** imageProductFormat */
    @ApiModelProperty(value = "")
    private String imageProductFormat;

    /** imageProductTime */
    @ApiModelProperty(value = "")
    private String imageProductTime;

    /** imageSatPath */
    @ApiModelProperty(value = "")
    private String imageSatPath;

    /** imageSatRow */
    @ApiModelProperty(value = "")
    private String imageSatRow;

    /** imageStartTime */
    @ApiModelProperty(value = "")
    private String imageStartTime;

    /** imageEndTime */
    @ApiModelProperty(value = "")
    private String imageEndTime;

    /** imageCenterTime */
    @ApiModelProperty(value = "")
    private String imageCenterTime;

    /** imageWidthInPixels */
    @ApiModelProperty(value = "")
    private String imageWidthInPixels;

    /** imagePitchSatellitessAngle */
    @ApiModelProperty(value = "")
    private String imagePitchSatellitessAngle;

    /** imageSolarAzimuth */
    @ApiModelProperty(value = "")
    private String imageSolarAzimuth;

    /** imageSolarZenith */
    @ApiModelProperty(value = "")
    private String imageSolarZenith;

    /** imageSatelliteAzimuth */
    @ApiModelProperty(value = "")
    private String imageSatelliteAzimuth;

    /** imageSatelliteZenith */
    @ApiModelProperty(value = "")
    private String imageSatelliteZenith;

    /** imageHeightInPixels */
    @ApiModelProperty(value = "")
    private String imageHeightInPixels;

    /** imageYawSatelliteAngle */
    @ApiModelProperty(value = "")
    private String imageYawSatelliteAngle;

    /** 校准任务ID */
    @ApiModelProperty(value = "校准任务ID")
    private String jobId;

    /** 校准图像结果 0 失败 1 成功 */
    @ApiModelProperty(value = "校准图像结果 0 失败 1 成功")
    private Integer correctStatus;

    /** 旧数据的关联影像id，兼容旧数据订单 */
    @ApiModelProperty(value = "旧数据的关联影像id，兼容旧数据订单")
    private String relationNo;

    /** 店铺id */
    @ApiModelProperty(value = "店铺id")
    private String shopId;

    /** 生产tif文件回调的jobid */
    @ApiModelProperty(value = "生产tif文件回调的jobid")
    private String tifJobId;

    /** 生产tif文件回调状态：0 默认 1 成功 2 失败 3更新生产tif */
    @ApiModelProperty(value = "生产tif文件回调状态：0 默认 1 成功 2 失败 3更新生产tif")
    private Integer tifTaskStatus;

    /** 生成josn更新时间 */
    @ApiModelProperty(value = "生成josn更新时间")
    private Timestamp jsonTaskDate;

    /** 生成json文件回调状态 0需要生成 1完成生成 -1 生成失败  2生成中 3请求失败 4已放入队列 */
    @ApiModelProperty(value = "生成json文件回调状态 0需要生成 1完成生成 -1 生成失败  2生成中 3请求失败 4已放入队列")
    private Integer jsonTaskStatus;

    /** imageYear */
    @ApiModelProperty(value = "")
    private Integer imageYear;

    /** imageYear */
    @ApiModelProperty(value = "")
    private Long dataId;

    @ApiModelProperty(value = "是否已经统计覆盖率")
    private Integer coverStatistics;


    @ApiModelProperty
    private Integer  status;
  }