package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.admin.constant.AdminCommonConstant;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ImageimgMenuBiz;
import com.upyuns.platform.rs.website.entity.DataMenu;
import com.upyuns.platform.rs.website.entity.ImageimgMenu;
import com.upyuns.platform.rs.website.vo.DataMenuTree;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("imageimgMenu/web")
public class ImageimgMenuController extends BaseController<ImageimgMenuBiz,ImageimgMenu> {

    @RequestMapping(value = "/app/unauth/imageimgMenuTree", method = RequestMethod.GET)
    @IgnoreUserToken
    @IgnoreClientToken
    @ResponseBody
    public ObjectRestResponse<List<DataMenuTree>> imageimgMenuTree(Integer parentId, Integer topicId) {
        try {
            if (parentId == null) {
                parentId = AdminCommonConstant.ROOT;
            }
        } catch (Exception e) {
            return ObjectRestResponse.succ(new ArrayList<DataMenuTree>());
        }
        List<DataMenuTree> trees = new ArrayList<DataMenuTree>();
        DataMenuTree node = null;
        Example example = new Example(DataMenu.class);
        ImageimgMenu parent = baseBiz.selectById(parentId);
        if(null != parent) {
            Example.Criteria criteria = example.createCriteria().andLike("path", parent.getPath() + "%").andNotEqualTo("id",parent.getId());
        }else {
            Example.Criteria criteria = example.createCriteria().andNotEqualTo("id",parentId);
        }
        example.setOrderByClause("order_num asc, id asc");
        return ObjectRestResponse.succ(baseBiz.getImageimgMenuTree(baseBiz.selectByExample(example), parentId));
    }
}