package com.upyuns.platform.rs.website.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.TModelBiz;
import com.upyuns.platform.rs.website.biz.TModelTypeBiz;
import com.upyuns.platform.rs.website.dto.TModelDTO;
import com.upyuns.platform.rs.website.dto.TModelTypeDTO;
import com.upyuns.platform.rs.website.entity.TModel;
import com.upyuns.platform.rs.website.entity.TModelType;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

@RestController
@RequestMapping("tModelType")
public class TModelTypeController extends BaseController<TModelTypeBiz, TModelType> {



    @GetMapping(value = "/app/unauth/getAll")
    @IgnoreUserToken
    public ObjectRestResponse getAll() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("softwareFramework", Arrays.asList("TensorFlow","pytorch","paddle","oneflow"));
        jsonObject.put("modelTypes",baseBiz.getAll());
        return ObjectRestResponse.succ(jsonObject);
    }


    @PostMapping(value = "/addUpdate")
    public ObjectRestResponse addUpdateV2(@RequestBody TModelType tModelType) {
        return baseBiz.addObj(tModelType);
    }


    @PostMapping(value = "/getList")
    public ObjectRestResponse getListV2(@RequestBody TModelTypeDTO tModelTypeDTO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("softwareFramework", Arrays.asList("TensorFlow","pytorch","paddle","oneflow"));
        jsonObject.put("modelTypes",baseBiz.getList(tModelTypeDTO));
        return ObjectRestResponse.succ(jsonObject);
    }


    @GetMapping(value = "/detail")
    public ObjectRestResponse detailV2(Integer id) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }


}
