package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.admin.constant.AdminCommonConstant;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.DataMenuBiz;
import com.upyuns.platform.rs.website.entity.DataMenu;
import com.upyuns.platform.rs.website.vo.DataMenuTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@RestController
@RequestMapping("/dataMenu")
public class AdmindataMenuController extends BaseController<DataMenuBiz, DataMenu> {

//    @Autowired
//    private MosaicimageBiz mosaicimageBiz;

    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<List<DataMenuTree>> getTree(String title) {
        Example example = new Example(DataMenu.class);
        if (StringUtils.isNotBlank(title)) {
            example.createCriteria().andLike("title", "%" + title + "%");
        }
        return ObjectRestResponse.succ(baseBiz.getImageMenuTree(baseBiz.selectByExample(example), AdminCommonConstant.ROOT));
    }
}