package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.TModelTypeDTO;
import com.upyuns.platform.rs.website.entity.ApiCustomNode;
import com.upyuns.platform.rs.website.entity.TModel;
import com.upyuns.platform.rs.website.entity.TModelType;
import com.upyuns.platform.rs.website.mapper.TModelMapper;
import com.upyuns.platform.rs.website.mapper.TModelTypeMapper;
import com.upyuns.platform.rs.website.vo.TModelTypeVo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

@Service
public class TModelTypeBiz extends BaseBiz<TModelTypeMapper, TModelType> {


    public List<TModelTypeVo> getAll() {
        List<TModelTypeVo> vos = new ArrayList<>();
        Example exampleModel = new Example(TModelType.class);
        exampleModel.createCriteria().andEqualTo("isDel", 0);
        List<TModelType> tModelTypes = mapper.selectByExample(exampleModel);
        for (TModelType tModelType : tModelTypes) {
            TModelTypeVo vo = new TModelTypeVo();
            BeanUtils.copyProperties(tModelType, vo);
            vos.add(vo);
        }
        List<TModelTypeVo> result = new ArrayList<>();
        for (TModelTypeVo vo : vos) {
            if (vo.getPid().equals(0)) {
                result.add(findChildren(vo, vos));
            }
        }

        return result;
    }


    public TModelTypeVo findChildren(TModelTypeVo vo, List<TModelTypeVo> treeNodes) {
        vo.setChildren(new ArrayList<>());
        for (TModelTypeVo it : treeNodes) {
            if (vo.getId().equals(it.getPid())) {
                vo.getChildren().add(it);
                findChildren(it, treeNodes);
            }
        }
        return vo;
    }

    public ObjectRestResponse addObj(TModelType tModelType) {
        if (tModelType == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        if (tModelType.getId() != null) {
            TModelType old = selectById(tModelType.getId());
            if (old == null || old.getIsDel() == 1) {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
            }
            BeanUtil.copyProperties(tModelType, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            updateSelectiveByIdRe(old);
        } else {
            insertSelectiveRe(tModelType);
        }
        return ObjectRestResponse.succ();
    }

    public PageInfo<?> getList(TModelTypeDTO tModelTypeDTO) {
        Query query = new Query(tModelTypeDTO);

        List<TModelTypeVo> vos = new ArrayList<>();
        List<TModelType> tModelTypes = mapper.selectList(query.getSuper());
        for (TModelType tModelType : tModelTypes) {
            TModelTypeVo vo = new TModelTypeVo();
            BeanUtils.copyProperties(tModelType, vo);
            vos.add(vo);
        }
        List<TModelTypeVo> result = new ArrayList<>();
        for (TModelTypeVo vo : vos) {
            if (vo.getPid().equals(0)) {
                result.add(findChildren(vo, vos));
            }
        }

        Page<TModelTypeVo> page = new Page(tModelTypeDTO.getPage(), tModelTypeDTO.getLimit());
        int total = result.size();
        page.setTotal(total);
        int startIndex = (tModelTypeDTO.getPage() - 1) * tModelTypeDTO.getLimit();
        int endIndex = Math.min(startIndex + tModelTypeDTO.getLimit(),total);
        if(startIndex>endIndex){
            page.addAll(new ArrayList());
            PageInfo<TModelTypeVo> pageInfo = new PageInfo<>(page);
            return pageInfo;
        }else{
            page.addAll(result.subList(startIndex,endIndex));
            PageInfo<TModelTypeVo> pageInfo = new PageInfo<>(page);
            return pageInfo;
        }
    }
}
