package com.upyuns.platform.rs.website.biz;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.website.dto.ServiceCapabilityDTO;
import com.upyuns.platform.rs.website.entity.ServiceCapability;

import com.upyuns.platform.rs.website.entity.TModel;
import com.upyuns.platform.rs.website.mapper.ServiceCapabilityMapper;
import org.springframework.stereotype.Service;

/**
 *
 */
@Service
public class ServiceCapabilityBiz extends BaseBiz<ServiceCapabilityMapper, ServiceCapability> {

    public ObjectRestResponse addObj(ServiceCapability serviceCapability) {
        if (serviceCapability == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        if (serviceCapability.getId() != null) {
            ServiceCapability old = selectById(serviceCapability.getId());
            if (old == null || old.getIsDel() == 1) {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
            }
            BeanUtil.copyProperties(serviceCapability, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            updateSelectiveByIdRe(old);
        } else {
            insertSelectiveRe(serviceCapability);
        }
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse getList(ServiceCapabilityDTO serviceCapabilityDTO) {
        Query query = new Query(serviceCapabilityDTO);
        PageDataVO<ServiceCapability> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
        return ObjectRestResponse.succ(pageDataVO);
    }

    public ObjectRestResponse get() {
        PageParam pageParam = new PageParam();
        pageParam.setPage(1);
        pageParam.setLimit(1);
        Query query = new Query(pageParam);
        PageDataVO<ServiceCapability> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
        try {
            return ObjectRestResponse.succ(pageDataVO.getData().get(0));
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createFailedResult(50000,e.toString());
        }
    }
}




