package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.constant.RestCode;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.NewsTypeDto;
import com.upyuns.platform.rs.website.entity.NewsType;
import com.upyuns.platform.rs.website.mapper.NewsTypeMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 新闻类型
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Service
public class NewsTypeBiz extends BaseBiz<NewsTypeMapper, NewsType> {

	public ObjectRestResponse add(NewsType newsType) {
		if (newsType == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (newsType.getId() != null) {
			NewsType old = selectById(newsType.getId());
			if (old == null) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			}
			if (StringUtils.isNotBlank(newsType.getNameCn())) {
				NewsType nameValue = getOneByName(newsType.getNameCn());
				if (nameValue != null && !nameValue.getId().equals(newsType.getId())) {
					return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "新闻分类名称已存在！");
				}
			}
			BeanUtil.copyProperties(newsType, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		} else {
			if (StringUtils.isNotBlank(newsType.getNameCn())) {
				NewsType nameValue = getOneByName(newsType.getNameCn());
				if (nameValue != null) {
					return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "新闻分类名称已存在！");
				}
			}
			insertSelectiveRe(newsType);
		}
		return ObjectRestResponse.succ();
	}

	public NewsType getOneByName(String newsTypeName) {
		Example example = new Example(NewsType.class);
		example.createCriteria().andEqualTo("isDel", 0).andEqualTo("nameCn", newsTypeName);
		return mapper.selectOneByExample(example);
	}

	/**
	 * 查询所有首页展示
	 * @return
	 */
	public ObjectRestResponse<List<NewsType>> getAll() {
		Example example = new Example(NewsType.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0).andEqualTo("status", 1);
		example.orderBy("rank");
		return ObjectRestResponse.succ(mapper.selectByExample(example));
	}


	/**
	 * 新闻咨询类型
	 * @param newsTypeDto
	 * @return
	 */
	public ObjectRestResponse<PageDataVO<NewsType>> selectList(NewsTypeDto newsTypeDto) {
		Example example = new Example(NewsType.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0);
		if (StringUtils.isNotBlank(newsTypeDto.getName())) {
			criteria.andLike("nameCn", "%" + newsTypeDto.getName() + "%");
		}
		example.orderBy("updTime").desc();
		Query query = new Query(newsTypeDto);
		PageDataVO<NewsType> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}

}