package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.collection.CollUtil;
import com.github.wxiaoqi.security.common.util.TreeUtil;
import com.github.wxiaoqi.security.common.vo.TreeNode;
import com.upyuns.platform.rs.website.entity.ImageImgStorage;
import com.upyuns.platform.rs.website.entity.ImageimgMenu;
import com.upyuns.platform.rs.website.vo.ImageimgMenuTree;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.mapper.ImageimgMenuMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 *
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-09-09 16:22:43
 */
@Service
public class ImageimgMenuBiz extends BaseBiz<ImageimgMenuMapper,ImageimgMenu> {

    @Autowired
    ImageImgStorageBiz imageImgStorageBiz;

    public List<ImageimgMenuTree> getImageimgMenuTree(List<ImageimgMenu> menus, int root) {
        List<ImageimgMenuTree> trees = new ArrayList<ImageimgMenuTree>();
        ImageimgMenuTree node = null;
        for (ImageimgMenu imageMenu : menus) {
            node = new ImageimgMenuTree();
            BeanUtils.copyProperties(imageMenu, node);
            node.setLabel(imageMenu.getTitle());
//            node.setElements(imageImgStorageBiz.selectAll(new ImageImgStorage(){{
//                setMenuId(imageMenu.getId());
//            }}));
            if (node.getChildren() == null) {
                node.setChildren(new ArrayList<>());
            }
            trees.add(node);
        }
        return TreeUtil.bulid(trees,root);
    }

    public List<ImageimgMenuTree> getImageMenuStatsTree(List<GainDataBiz.DataMenuStats> menus, int root) {
        List<ImageimgMenuTree> trees = new ArrayList<ImageimgMenuTree>();
        ImageimgMenuTree node = null;
        for (GainDataBiz.DataMenuStats imageMenu : menus) {
            node = new ImageimgMenuTree();
            BeanUtils.copyProperties(imageMenu, node);
            node.setLabel(imageMenu.getTitle());
            node.setDataNum(imageMenu.getDataNum());
            if (node.getChildren() == null) {
                node.setChildren(new ArrayList<>());
            }
            trees.add(node);
        }
        return TreeUtil.bulid(trees,root);
    }

    public List<ImageimgMenuTree> getImageMenuTreeNoElements(List<ImageimgMenu> menus, int root) {
        List<ImageimgMenuTree> trees = new ArrayList<ImageimgMenuTree>();
        ImageimgMenuTree node = null;
        for (ImageimgMenu imageMenu : menus) {
            node = new ImageimgMenuTree();
            BeanUtils.copyProperties(imageMenu, node);
            node.setLabel(imageMenu.getTitle());
            if (node.getChildren() == null) {
                node.setChildren(new ArrayList<>());
            }
            trees.add(node);
        }
        return TreeUtil.bulid(trees,root);
    }

    public List<Integer> getIdsByTopId(int root) {
        Example exampleDataMenu = new Example(ImageimgMenu.class);
        exampleDataMenu.createCriteria().andNotEqualTo("id", root);
        exampleDataMenu.setOrderByClause("order_num asc, id asc");
        List<ImageimgMenu> menus = selectByExample(exampleDataMenu);
        List<Integer> list = CollUtil.newArrayList(root);
        List<ImageimgMenuTree> trees = getImageMenuTreeNoElements(menus, root);
        dealIds(trees, list);
        return list;
    }

    public void dealIds(List<? extends TreeNode> menuTrees, List<Integer> ids) {
        if(CollUtil.isNotEmpty(menuTrees)) {
            for(TreeNode ImageimgMenuTree : menuTrees) {
                ids.add(ImageimgMenuTree.getId());
                dealIds(ImageimgMenuTree.getChildren(), ids);
            }
        }
    }

    public List<Integer> getIdsByBottomId(int root, List<Integer> list) {
        Example exampleDataMenu = new Example(ImageimgMenu.class);
        exampleDataMenu.createCriteria().andEqualTo("id", root);
        exampleDataMenu.setOrderByClause("order_num asc, id asc");
        List<ImageimgMenu> menus = selectByExample(exampleDataMenu);
        if(CollUtil.isEmpty(list)) {
            list = CollUtil.newArrayList(root);
        }else {
            list.add(root);
        }
        if(CollUtil.isNotEmpty(menus) && -1 != menus.get(0).getParentId()) {
            return getIdsByBottomId(menus.get(0).getParentId(), list);
        }else {
            return list;
        }
    }
}