package com.upyuns.platform.rs.website.biz;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.ApiDocDTO;
import com.upyuns.platform.rs.website.entity.*;
import com.upyuns.platform.rs.website.mapper.ApiCustomNodeMapper;
import com.upyuns.platform.rs.website.mapper.ApiCustomParamsMapper;
import com.upyuns.platform.rs.website.mapper.ApiDocMapper;


import com.upyuns.platform.rs.website.vo.ApiCustomNodeVo;
import com.upyuns.platform.rs.website.vo.ApiDocTreeVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 *
 */
@Service
public class ApiDocBiz extends BaseBiz<ApiDocMapper, ApiDoc> {


    @Resource
    private ApiCustomNodeMapper nodeMapper;

    @Resource
    private ApiCustomParamsMapper paramsMapper;


    public ObjectRestResponse getList(ApiDocDTO apiDocDTO) {
        Query query = new Query(apiDocDTO);
        Example exampleNode = new Example(ApiCustomNode.class);
        Example exampleParams = new Example(ApiCustomParams.class);
        PageDataVO<ApiDocTreeVo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
        for (ApiDocTreeVo apiDocTreeVo : pageDataVO.getData()) {
            exampleNode.clear();
            if (StringUtils.isNotBlank(apiDocDTO.getKeyWord())) {
                exampleNode.createCriteria()
                        .andEqualTo("isDel", 0)
                        .andLike("nodeName", '%' + apiDocDTO.getKeyWord() + '%')
                        .andEqualTo("docId", apiDocTreeVo.getId());
            } else {
                exampleNode.createCriteria()
                        .andEqualTo("isDel", 0)
                        .andEqualTo("docId", apiDocTreeVo.getId());
            }
            exampleNode.excludeProperties("respondJson");
            List<ApiCustomNodeVo> nodeVos = nodeMapper.selectByExample(exampleNode).stream().map(apiCustomNode -> {
                ApiCustomNodeVo nodeVoss = new ApiCustomNodeVo();
                BeanUtils.copyProperties(apiCustomNode, nodeVoss);
                nodeVoss.setNodeId(apiCustomNode.getId());
                exampleParams.clear();
                exampleParams.createCriteria()
                        .andEqualTo("nodeId", apiCustomNode.getId())
                        .andEqualTo("isDel", 0)
                        .andEqualTo("docId", apiDocTreeVo.getId());
                ApiCustomParams params = paramsMapper.selectOneByExample(exampleParams);
                if (Objects.isNull(params)) {
                    return nodeVoss;
                }
                nodeVoss.setParamId(params.getId());
                nodeVoss.setMethod(params.getMethod());
                return nodeVoss;
            }).collect(Collectors.toList());
            apiDocTreeVo.setApiCount(nodeVos.size());
            apiDocTreeVo.setNodeVoList(nodeVos);
        }
        return ObjectRestResponse.succ(pageDataVO);
    }

    public ObjectRestResponse addObj(ApiDoc apiDoc) {
        if (apiDoc == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        if (apiDoc.getId() != null) {
            ApiDoc old = selectById(apiDoc.getId());
            if (old == null || old.getIsDel() == 1) {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
            }
            BeanUtil.copyProperties(apiDoc, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            updateSelectiveByIdRe(old);
        } else {
            insertSelectiveRe(apiDoc);
        }
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse getListV2(ApiDocDTO apiDocDTO) {
        Query query = new Query(apiDocDTO);
        PageDataVO<ApiDoc> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectListV2(query.getSuper()));
        return ObjectRestResponse.succ(pageDataVO);
    }
}




