package com.upyuns.platform.rs.website.biz;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.ApiCustomParamsDTO;
import com.upyuns.platform.rs.website.entity.ApiCustomNode;
import com.upyuns.platform.rs.website.entity.ApiCustomParams;
import com.upyuns.platform.rs.website.entity.ApiDoc;
import com.upyuns.platform.rs.website.mapper.ApiCustomNodeMapper;
import com.upyuns.platform.rs.website.mapper.ApiCustomParamsMapper;


import com.upyuns.platform.rs.website.mapper.ApiDocMapper;
import jodd.util.StringUtil;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import javax.annotation.Resource;
import java.util.Objects;

/**
 *
 */
@Service
public class ApiCustomParamsBiz extends BaseBiz<ApiCustomParamsMapper, ApiCustomParams> {

    @Resource
    private ApiCustomNodeMapper apiCustomNodeMapper;
    @Resource
    private ApiDocMapper apiDocMapper;


    public ObjectRestResponse addObj(ApiCustomParams apiCustomParams) {
        if (apiCustomParams == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        //判断文档是否存在
        if (Objects.nonNull(apiCustomParams.getDocId()) && apiCustomParams.getDocId() > 0){
            Example exampleDoc = new Example(ApiDoc.class);
            exampleDoc.createCriteria()
                    .andEqualTo("id", apiCustomParams.getDocId())
                    .andEqualTo("isDel",0);
           if(apiDocMapper.selectCountByExample(exampleDoc) <= 0){
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, "文档不存在");
           }
        }
        //判断API节点是否存在
        if (Objects.nonNull(apiCustomParams.getNodeId()) && apiCustomParams.getNodeId() > 0){
            Example exampleNode = new Example(ApiCustomNode.class);
            exampleNode.createCriteria()
                    .andEqualTo("id", apiCustomParams.getNodeId())
                    .andEqualTo("isDel",0);
            if(apiCustomNodeMapper.selectCountByExample(exampleNode) <= 0){
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, "API节点不存在");
            }
            Example exampleParams = new Example(ApiCustomParams.class);
            exampleParams.createCriteria()
                    .andNotEqualTo("id", apiCustomParams.getId() != null? apiCustomParams.getId() : 0)
                    .andEqualTo("nodeId", apiCustomParams.getNodeId())
                   .andEqualTo("isDel",0);
            if(mapper.selectCountByExample(exampleParams) > 0){
                return ObjectRestResponse.createFailedResult(ResultCode.EXIST_CODE, "API节点下已存在自定义参数");
            }
        }
        if (apiCustomParams.getId() != null) {
            ApiCustomParams old = selectById(apiCustomParams.getId());
            if (old == null || old.getIsDel() == 1) {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
            }
            BeanUtil.copyProperties(apiCustomParams, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            updateSelectiveByIdRe(old);
        } else {
            insertSelectiveRe(apiCustomParams);
        }
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse getListV2(ApiCustomParamsDTO apiCustomParamsDTO) {
        Query query = new Query(apiCustomParamsDTO);
        PageDataVO<ApiCustomParams> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
        return ObjectRestResponse.succ(pageDataVO);
    }

}




