package com.upyuns.platform.rs.website.type;

/**
 * @ClassName : OrderTypeEnum
 * @Description : 订单类型
 * @Author : jiaoruizhen
 * @Date: 2020-12-12 16:50
 */
public enum OrderTypeEnum {
	STANDARD_DATA(1, "标准数据"),
	INDUSTRY_INFO(3, "行业应用"),
	IMAGE_STORAGE(2, "影像图库"),
	SHOPPING_CART_INFO(4, "购物车下单");
	private Integer type;
	private String msg;

	OrderTypeEnum(Integer type, String msg) {
		this.type = type;
		this.msg = msg;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}


	public static <T extends OrderTypeEnum> String getType(Integer code, Class<T> t) {
		for (T item : t.getEnumConstants()) {
			if (item.getType().equals(code)) {
				return item.getMsg();
			}
		}
		return "";
	}

	public static OrderTypeEnum getByCode(Integer code) {
		for (OrderTypeEnum v : values()) {
			if (v.getType() == code) {
				return v;
			}
		}
		return null;
	}

	public static String getProductStatusEnum(Integer code) {
		return getType(code, OrderTypeEnum.class);
	}

}
