package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单发票
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Data
@Table(name = "order_e_invoice")
public class OrderEInvoice implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  发票类型：1--租房车；2--房车游；3--会员
     */
    @Column(name = "type")
	@ApiModelProperty(value = "发票类型：1--租房车；2--房车游；3--会员")
    private Integer type;
	
	    /**
     *  订单ids，逗号分隔
     */
    @Column(name = "order_ids")
	@ApiModelProperty(value = "订单ids，逗号分隔")
    private String orderIds;
	
	    /**
     *  发票抬头类型：1--企业单位；2--个人/非企业单位
     */
    @Column(name = "title_type")
	@ApiModelProperty(value = "发票抬头类型：1--企业单位；2--个人/非企业单位")
    private Integer titleType;
	
	    /**
     *  抬头名称
     */
    @Column(name = "title_name")
	@ApiModelProperty(value = "抬头名称")
    private String titleName;
	
	    /**
     *  税号
     */
    @Column(name = "tax_code")
	@ApiModelProperty(value = "税号")
    private String taxCode;
	
	    /**
     *  发票内容-备注说明
     */
    @Column(name = "content_remark")
	@ApiModelProperty(value = "发票内容-备注说明")
    private String contentRemark;
	
	    /**
     *  发票内容-地址和电话
     */
    @Column(name = "content_contact")
	@ApiModelProperty(value = "发票内容-地址和电话")
    private String contentContact;
	
	    /**
     *  发票内容-开户行和账号
     */
    @Column(name = "content_account")
	@ApiModelProperty(value = "发票内容-开户行和账号")
    private String contentAccount;
	
	    /**
     *  发票方
     */
    @Column(name = "drawer")
	@ApiModelProperty(value = "发票方")
    private String drawer;
	
	    /**
     *  更多内容
     */
    @Column(name = "extend")
	@ApiModelProperty(value = "更多内容")
    private String extend;
	
	    /**
     *  金额
     */
    @Column(name = "amount")
	@ApiModelProperty(value = "金额")
    private BigDecimal amount;
	
	    /**
     *  接收方式：1--邮件
     */
    @Column(name = "receive_type")
	@ApiModelProperty(value = "接收方式：1--邮件")
    private Integer receiveType;
	
	    /**
     *  接收方式内容
     */
    @Column(name = "receive_content")
	@ApiModelProperty(value = "接收方式内容")
    private String receiveContent;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  创建者id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "创建者id")
    private Integer userId;
	
	    /**
     *  更新者id
     */
    @Column(name = "user_upd")
	@ApiModelProperty(value = "更新者id")
    private Integer userUpd;
	
	    /**
     *  
     */
    @Column(name = "invoice_url")
	@ApiModelProperty(value = "")
    private String invoiceUrl;
	
	    /**
     *  开票状态 0:未开票;1:开票中;2:为开票成功;3:开票失败;
     */
    @Column(name = "status")
	@ApiModelProperty(value = "开票状态 0:未开票;1:开票中;2:为开票成功;3:开票失败;")
    private Integer status;
	
	    /**
     *  发票内容
     */
    @Column(name = "content_title")
	@ApiModelProperty(value = "发票内容")
    private String contentTitle;


	/**
	 * 快递单号
	 */
	String trackingNumber;

	/**
	 * 快递单图片
	 */
	String trackingImg;

}
