package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 新闻类型
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Data
@Table(name = "news_type")
public class NewsType implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  中文名称
     */
    @Column(name = "name_cn")
	@ApiModelProperty(value = "中文名称")
    private String nameCn;
	
	    /**
     *  英文名称
     */
    @Column(name = "name_en")
	@ApiModelProperty(value = "英文名称")
    private String nameEn;
	
	    /**
     *  排序
     */
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	    /**
     *  是否删除：0、否，1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否，1、是")
    private Integer isDel;
	
	    /**
     *  是否启用：1、启用，2、禁用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "是否启用：1、启用，2、禁用")
    private Integer status;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	

}
