package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 行业应用类型
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Data
@Table(name = "industry_application_type")
public class IndustryApplicationType implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  行业应用类型标题
     */
    @Column(name = "title")
	@ApiModelProperty(value = "行业应用类型标题")
    private String title;
	
	    /**
     *  详细介绍
     */
    @Column(name = "detail")
	@ApiModelProperty(value = "详细介绍")
    private String detail;
	
	    /**
     *  封面图
     */
    @Column(name = "cover_img")
	@ApiModelProperty(value = "封面图")
    private String coverImg;
	
	    /**
     *  详情图
     */
    @Column(name = "detail_img")
	@ApiModelProperty(value = "详情图")
    private String detailImg;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;
	
	    /**
     *  是否启用，1、启用，2、禁用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "是否启用，1、启用，2、禁用")
    private Integer status;
	
	    /**
     *  排序字段
     */
    @Column(name = "rank")
	@ApiModelProperty(value = "排序字段")
    private Integer rank;
	
	    /**
     *  是否删除：0、否，1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否，1、是")
    private Integer isDel;
	
	    /**
     *  是否首页展示：1、展示，2、不展示
     */
    @Column(name = "index_show")
	@ApiModelProperty(value = "是否首页展示：1、展示，2、不展示")
    private Integer indexShow;
	
	    /**
     *  父级id：为0时是1级
     */
    @Column(name = "pid")
	@ApiModelProperty(value = "父级id：为0时是1级")
    private Integer pid;
	

}
