package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 影像图库上传图片关联信息
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-04 14:38:23
 */
@Data
@Table(name = "image_info_relation")
public class ImageInfoRelation implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  图片链接
     */
    @Column(name = "url")
	@ApiModelProperty(value = "图片链接")
    private String url;
	
	    /**
     *  文件类型
     */
    @Column(name = "file_type")
	@ApiModelProperty(value = "文件类型")
    private String fileType;
	
	    /**
     *  文件大小
     */
    @Column(name = "file_size")
	@ApiModelProperty(value = "文件大小")
    private String fileSize;
	
	    /**
     *  文件尺寸
     */
    @Column(name = "file_width")
	@ApiModelProperty(value = "文件尺寸")
    private String fileWidth;
	
	    /**
     *  关联id
     */
    @Column(name = "relation_id")
	@ApiModelProperty(value = "关联id")
    private Integer relationId;
	
	    /**
     *  类型
     */
    @Column(name = "type")
	@ApiModelProperty(value = "类型")
    private Integer type;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;

	/**
	 * 价格
	 */
	private BigDecimal price;
	

}
