package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 文件表
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-06-04 19:14:26
 */
@Data
@Table(name = "file_data")
public class FileData implements Serializable {
	private static final long serialVersionUID = 1L;

    public static final int HASGTDATA_NOT = 0;
    public static final int HASGTDATA_FIN = 1;
    public static final int HASGTDATA_UPD = 2;

    public static final int STORAGETYPE_UPLOAD = 1;
    public static final int STORAGETYPE_GTDATA = 2;

	    /**
    *  主键
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  文件名称
     */
    @Column(name = "filename")
	@ApiModelProperty(value = "文件名称")
    private String filename;
	
	    /**
     *  文件类型
     */
    @Column(name = "filetype")
	@ApiModelProperty(value = "文件类型")
    private String filetype;
	
	    /**
     *  文件大小
     */
    @Column(name = "filesize")
	@ApiModelProperty(value = "文件大小")
    private    String filesize;


    @ApiModelProperty(value = "文件地址")
    private String fileurl;
	    /**
     *  成果id
     */
    @Column(name = "gain_id")
	@ApiModelProperty(value = "成果id")
    private Integer gainId;


    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除 1--已删除；0--未删除")
    private Integer isDel;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;

    @ApiModelProperty(value = "文件服务器路径")
    private String filepath;

    @Column(name = "gtdata_path")
    @ApiModelProperty(value = "gtdata路径")
    private String gtdataPath;

    @Column(name = "has_gtdata")
    @ApiModelProperty(value = "是否已经存储gtdata 0--未处理；1--已处理；2--已更新")
    private Integer hasGtdata;

    @Column(name = "storagetype")
    @ApiModelProperty(value = "存储类型 1--服务器；2--gtdata")
    private Integer storagetype;

    @Column(name = "datatemp_id")
    @ApiModelProperty(value = "数据临时缓存库 id")
    private Integer datatempId;
}
