package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 反馈信息
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2020-12-22 13:38:56
 */
@Data
@Table(name = "feedback_info")
public class FeedbackInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  姓名
     */
    @Column(name = "name")
	@ApiModelProperty(value = "姓名")
    private String name;
	
	    /**
     *  联系电话
     */
    @Column(name = "phone")
	@ApiModelProperty(value = "联系电话")
    private String phone;
	
	    /**
     *  内容
     */
    @Column(name = "content")
	@ApiModelProperty(value = "内容")
    private String content;
	
	    /**
     *  
     */
    @Column(name = "order_no")
	@ApiModelProperty(value = "")
    private String orderNo;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	
	    /**
     *  
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "")
    private Integer userId;
	
	    /**
     *  1、联系客服，2、意见反馈，3、订单反馈
     */
    @Column(name = "type")
	@ApiModelProperty(value = "1、联系客服，2、意见反馈，3、订单反馈")
    private Integer type;

	/**
	 * 客服回复信息
	 */
	private String responseInfo;
}
