package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 菜单
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-05-15 18:31:37
 */
@Data
@Table(name = "data_menu")
public class DataMenu implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  标题
     */
    @Column(name = "title")
	@ApiModelProperty(value = "标题")
    private String title;
	
	    /**
     *  父级节点
     */
    @Column(name = "parent_id")
	@ApiModelProperty(value = "父级节点")
    private Integer parentId;
	
	    /**
     *  排序
     */
    @Column(name = "order_num")
	@ApiModelProperty(value = "排序")
    private Integer orderNum;
	
	    /**
     *  描述
     */
    @Column(name = "description")
	@ApiModelProperty(value = "描述")
    private String description;
	
	    /**
     *  菜单上下级关系
     */
    @Column(name = "path")
	@ApiModelProperty(value = "菜单上下级关系")
    private String path;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "")
    private String crtUser;
	
	    /**
     *  
     */
    @Column(name = "crt_name")
	@ApiModelProperty(value = "")
    private String crtName;
	
	    /**
     *  
     */
    @Column(name = "crt_host")
	@ApiModelProperty(value = "")
    private String crtHost;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	
	    /**
     *  
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "")
    private String updUser;
	
	    /**
     *  
     */
    @Column(name = "upd_name")
	@ApiModelProperty(value = "")
    private String updName;
	
	    /**
     *  
     */
    @Column(name = "upd_host")
	@ApiModelProperty(value = "")
    private String updHost;
	

}
