package com.upyuns.platform.rs.website.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 *
 * @TableName api_doc
 */
@Table(name="api_doc")
@Data
public class ApiDoc implements Serializable {
    /**
     *
     */
    @Id
    private Integer id;

    /**
     * 文档名称
     */
    private String name;

    /**
     * 文档类型
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 文档URL地址
     */
    @Column(name = "doc_url")
    private String docUrl;

    /**
     * 文档下载地址
     */
    @Column(name = "download_url")
    private String downloadUrl;

    /**
     * 路由
     */
    @Column(name = "path")
    private String path;

    /**
     * 文档json内容
     */
    @Column(name = "json_content")
    private String jsonContent;

    /**
     * 重写的域名
     */
    @Column(name = "rewrite_domain")
    private String rewriteDomain;

    /**
     * 是否开放访问 0=否 1=是
     */
    @Column(name = "open_visit")
    private Byte openVisit;

    /**
     * 开放文档UUID
     */
    @Column(name = "share_uuid")
    private String shareUuid;

    /**
     * 开放文档使用说明
     */
    @Column(name = "share_instruction")
    private String shareInstruction;

    /**
     * 状态：1.上架 2.下架
     */
    private Byte status;

    /**
     * 是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
    private Byte isDel;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(name = "create_user")
    private Long createUser;

    /**
     * 更新时间
     */
    @Column(name = "last_update_time")
    private Date lastUpdateTime;

    /**
     * 更新人
     */
    @Column(name = "last_update_user")
    private Long lastUpdateUser;

    private static final long serialVersionUID = 1L;
}
