package com.upyuns.platform.rs.website.dto;

import com.github.wxiaoqi.security.common.vo.PageParam;
import lombok.Data;

/**
 * @ClassName : UserOrderDto
 * @Description : 用户订单查询
 * @Author : jiaoruizhen
 * @Date: 2020-12-03 17:32
 */
@Data
public class UserOrderDto extends PageParam {

	//订单状态：1--创建订单，2--待付款，3--已支付，4--已发货,5--已完成 -1、删除，-2、取消
	Integer status;

	//订单状态：1--创建订单，2--待付款，3--已支付，4--已发货,5--已完成 -1、删除，-2、取消
	Integer newStatus;

	//审核状态： 1、审核通过，2、审核拒绝
	Integer auditStatus;

	//商品名称
	String name;

	//开始时间
	String startTime;

	//结束时间
	String endTime;

	//关键字
	String keywords;

	//支付状态: 1、已支付，2、未支付
	Integer payStatus;

	//用户id
	Integer userId;

	/**
	 * 订单号
	 */
	String orderNo;

	/**
	 * 昵称
	 */
	String nickname;

	/**
	 * 手机号
	 */
	String phone;

	/**
	 * 配送方式:1、线上配送，2、快递配送
	 */
	Integer sendType;

	/**
	 * 1、普通订单，2、定制订单
	 */
	Integer type;

	/**
	 * 发票状态： 1、未开发票，2、已开发票, 3、已发货， 4、已收货、5、退回， 6、已完成
	 */
	Integer invoiceStatus;

	/**
	 * 卫星标识
	 */
	String satellite;
}
