package com.upyuns.platform.rs.universal.service;

import com.upyuns.platform.rs.universal.constant.CaptchaType;

/**
 * @author stx
 * @date 2018/11/5 11:11
 * @desc
 */
public class CaptchaFactory implements ICaptchaFactory{

    @Override
    public AbstractCaptcha getInstance(CaptchaType captchaType) {
        if (CaptchaType.CLICK_WORD.getName().equals(captchaType.getName())){
            return new ClickWordCaptcha();
        } else if (CaptchaType.BLOCK_PUZZLE.getName().equals(captchaType.getName())) {
            return new BlockPuzzleCaptcha();
        }
        return null;
    }

}
