package com.upyuns.platform.rs.universal.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import javax.servlet.MultipartConfigElement;

@Configuration
public class CommonConfig {

    @Value("${spring.servlet.multipart.max-request-size}")
    private String maxFileSize;
    @Value("${spring.servlet.multipart.max-file-size}")
    private String maxRequestSize;

    @Value("${spring.servlet.multipart.location}")
    private String location;

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        // 单个数据大小
        factory.setMaxFileSize(maxFileSize);
        // 总上传数据大小
        factory.setMaxRequestSize(maxRequestSize);
        factory.setLocation(location);
        return factory.createMultipartConfig();
    }

//    @Bean
//    public MultipartConfigElement multipartConfigElement() {
//        MultipartConfigFactory factory = new MultipartConfigFactory();
//        //  单个数据大小
//        factory.setMaxFileSize("102400KB"); // KB,MB
//        /// 总上传数据大小
//        factory.setMaxRequestSize("502400KB");
//        return factory.createMultipartConfig();
//    }
}