package com.upyuns.platform.rs.universal.biz;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.upyuns.platform.rs.universal.mapper.OrderRefundMapper;
import com.upyuns.platform.rs.universal.entity.OrderPay;
import com.upyuns.platform.rs.universal.entity.OrderRefund;
import com.upyuns.platform.rs.universal.vo.OrderRefundVo;
import com.upyuns.platform.rs.universal.weixin.api.WxPayRefundUtils;
import com.upyuns.platform.rs.universal.weixin.util.Snowflake;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 订单支付退款表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Service
@Slf4j
public class OrderRefundBiz extends BaseBiz<OrderRefundMapper, OrderRefund> {

    @Autowired
    private OrderPayBiz payBiz;
    @Value("${universal.cert}")
    private String APICLIENT_CERT;

    @Autowired
    DictionaryBiz dictionaryBiz;

    public ObjectRestResponse tradeRefund(String tradNo, Integer refundAmount, String refundReason, String outRequestNo) {
        AlipayTradeRefundResponse refundResponse = payBiz.testTradeRefund(tradNo, refundAmount, refundReason, outRequestNo);
        log.info("预授权转支付退款： {}", refundResponse.getBody());
        if (refundResponse == null) {
            return ObjectRestResponse.createFailedResult(1002, "预授权转支付失败！");
        }
        OrderRefund orderRefund = selectByTradNo(tradNo);
        if (orderRefund == null) {
            return ObjectRestResponse.createFailedResult(1003, "预授权转支付商户订单不存在！");
        }
        orderRefund.setRefundTradeNo(outRequestNo);
        orderRefund.setId(null);
        if (refundResponse.getTradeNo() != null) {
            orderRefund.setSerialNumber(refundResponse.getTradeNo());
        }
        orderRefund.setRefundAmount(refundAmount);
        orderRefund.setRefundDesc(refundReason + "  预授权转支付商户订单号是：" + tradNo);
        orderRefund.setFinishTime(System.currentTimeMillis());
        orderRefund.setCrtTime(System.currentTimeMillis());
        orderRefund.setUpdTime(System.currentTimeMillis());
        mapper.insertSelective(orderRefund);
        return ObjectRestResponse.succ(orderRefund);
    }

    public OrderRefund selectByTradNo(String refundTradeNo) {
        if (StringUtils.isNotBlank(refundTradeNo)) {
            Example example = new Example(OrderRefund.class);
            example.createCriteria().andEqualTo("refundTradeNo", refundTradeNo);
            OrderRefund orderRefund = mapper.selectOneByExample(example);
            return orderRefund;
        }
        return null;
    }
}