package com.upyuns.platform.rs.universal.feign;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.upyuns.platform.rs.universal.dto.SendMsgDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(value = "rs-universal", contextId = "sendMessage")
public interface MQSenderFeign {

    @GetMapping(value = "/message/sendMessage")
    public ObjectRestResponse sendMessage(@RequestParam(value = "exchange") String exchange, @RequestParam(value = "routKey")String routKey, @RequestParam(value = "json") String json);

    @PostMapping(value = "/message/sendMessage")
    public ObjectRestResponse postSendMessage(@RequestBody SendMsgDTO dto);

}
