//package com.upyuns.platform.rs.universal.fastservice.api;
//
//
//import com.alibaba.fastjson.JSONObject;
//import com.github.wxiaoqi.security.common.util.HTTPSUtils;
//import com.github.wxiaoqi.security.common.util.process.SystemConfig;
//import EventNotifyRequestDto;
//import RequestBodyDto;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.stereotype.Service;
//
//import java.util.HashMap;
//import java.util.Map;
//
//@Slf4j
//@Service
//public class FastServiceApi {
//
//    public String getAccessToken(String code) {
//        RequestBodyDto requestBodyDto = new RequestBodyDto(SystemConfig.HUAWEI_FAST_SERVICE_GRANT_TYPE_AUTH,
//                SystemConfig.HUAWEI_FAST_SERVICE_CLIENT_ID,
//                SystemConfig.HUAWEI_FAST_SERVICE_CLIENT_SECRET,
//                code,
//                SystemConfig.HUAWEI_FAST_SERVICE_REDIRECT_URI);
//        String paramString = requestBodyDto.getParamMap();
//        log.info("获取token参数列表： param = {}", paramString);
//        Map<String, String> headers = new HashMap<>();
//        headers.put("Content-Type", "application/x-www-form-urlencoded");
//        try {
//            String result = HTTPSUtils.post(SystemConfig.HUAWEI_FAST_SERVICE_GET_TOKEN, paramString, headers);
//            log.info("获取token返回结果： result = {}", result);
//            return result;
//        } catch (Exception e) {
//            log.info("获取token返回失败");
//            log.error(e.getMessage(), e);
//        }
//      return null;
//    }
//
//    public String refreshAccessToken(String refreshToken) {
//        RequestBodyDto requestBodyDto = new RequestBodyDto(SystemConfig.HUAWEI_FAST_SERVICE_GRANT_TYPE_REFRESH_TOKEN,
//                refreshToken,
//                SystemConfig.HUAWEI_FAST_SERVICE_CLIENT_ID,
//                SystemConfig.HUAWEI_FAST_SERVICE_CLIENT_SECRET
//                );
//        String paramString = requestBodyDto.getParamMap();
//        Map<String, String> headers = new HashMap<>();
//        headers.put("Content-Type", "application/x-www-form-urlencoded");
//        try {
//            String result = HTTPSUtils.post(SystemConfig.HUAWEI_FAST_SERVICE_GET_TOKEN, paramString, headers);
//            log.info("刷新token返回结果： result = {}", result);
//            return result;
//        } catch (Exception e) {
//            log.info("刷新token返回失败");
//            log.error(e.getMessage(), e);
//        }
//        return null;
//    }
//    public String getOpenId(String accessToken) {
//        RequestBodyDto requestBodyDto = new RequestBodyDto(SystemConfig.HUAWEI_FAST_SERVICE_NSP_SVC,
//                SystemConfig.HUAWEI_FAST_SERVICE_OPEN_ID,
//                accessToken
//        );
//        String paramString = requestBodyDto.getParamMap();
//        log.info("获取openId参数列表： param = {}", paramString);
//        Map<String, String> headers = new HashMap<>();
//        headers.put("Content-Type", "application/x-www-form-urlencoded");
//        try {
//            String result = HTTPSUtils.post(SystemConfig.HUAWEI_FAST_SERVICE_GET_OPENID, paramString, headers);
//            log.info("获取openId返回结果： result = {}", result);
//            return result;
//        } catch (Exception e) {
//            log.info("获取openId返回失败");
//            log.error(e.getMessage(), e);
//        }
//        return null;
//    }
//
//    public String eventNotify(EventNotifyRequestDto eventNotifyRequestDto) {
//        Map<String, String> headers = new HashMap<>();
//        headers.put("x-appid", SystemConfig.HUAWEI_FAST_SERVICE_CLIENT_ID);
//        headers.put("Authorization", eventNotifyRequestDto.getOAuthToken().getAccessToken());
//        headers.put("Content-Type", "application/json");
//        headers.put("Accept", "application/json");
//        String paramString = JSONObject.toJSONString(eventNotifyRequestDto);
//        log.info("事件通知参数列表： param = {}", paramString);
//        try {
//            String result = HTTPSUtils.post(SystemConfig.HUAWEI_FAST_SERVICE_EVENT_NOTIFY, paramString, headers);
//            log.info("事件通知返回： result = {}", result);
//            return result;
//        } catch (Exception e) {
//            log.info("事件通知返回失败");
//            log.error(e.getMessage(), e);
//        }
//        return null;
//    }
//
//    public static void main(String[] args) {
//        FastServiceApi fastServiceApi = new FastServiceApi();
//
//    }
//}
