package com.upyuns.platform.rs.universal.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import tk.mybatis.mapper.annotation.KeySql;
import tk.mybatis.mapper.code.IdentityDialect;

import javax.persistence.Column;
import javax.persistence.Id;
import java.util.Date;

@Data
public class SearchableCity {

    @Id
    @KeySql(dialect = IdentityDialect.MYSQL)

    private Integer id;


    private String code;


    @Column(name = "city_name")
    private String cityName;


    @Column(name = "create_date")
    @DateTimeFormat(pattern ="yyyy-MM-dd HH:mm:ss" )
    @JsonFormat(timezone = "GMT-8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;


    @Column(name = "update_date")
    @DateTimeFormat(pattern ="yyyy-MM-dd HH:mm:ss" )
    @JsonFormat(timezone = "GMT-8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

}
