package com.upyuns.platform.rs.datacenter.rest.backstage;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.AssertUtils;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.datacenter.biz.RscpAreaImageTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImagePriceBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaImageTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import com.upyuns.platform.rs.datacenter.pojo.ImageDataVO;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.BgImageQueryDTO;
import com.upyuns.platform.rs.gtdata.GtDataRestClient;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/bg/imageData")
public class BgRscpImageDataTotalController extends BaseController<RscpImageDataTotalBiz, RscpImageDataTotal> {

    @Autowired
    GtDataRestClient gtDataRestClient;

    @Autowired
    RscpAreaImageTotalBiz rscpAreaImageTotalBiz;

    @ApiOperation("查询分页")
    @RequestMapping(value = "/bgPages",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<PageDataVO<RscpImageDataTotal>> bgPages(BgImageQueryDTO dto) {
        return ObjectRestResponse.succ(PageDataVO.pageInfo(dto.initQuery(), () -> baseBiz.bgQueryDataList(dto)));
    }

    @RequestMapping(value = "/completeDelete", method = RequestMethod.DELETE)
    public ObjectRestResponse completeDelete(Long id){
        AssertUtils.isBlank(id);
        //查询db
        RscpImageDataTotal dbImage = baseBiz.selectById(id);
        AssertUtils.isBlank(dbImage);

        if("/rscloudmart/bg/upload/2021-01-05/1609838996306.png".equals(dbImage.getImageFilePath())) {
            //假数据不删data
        }else {
            gtDataRestClient.delete(dbImage.getImageFilePath());
        }

        //删除业务数据
        baseBiz.deleteById(dbImage.getId());

        rscpAreaImageTotalBiz.delete(new RscpAreaImageTotal(){{
            setDataId(dbImage.getId());
        }});

        return ObjectRestResponse.succ(id);
    }


//    @ApiOperation("上下架")
//    @RequestMapping(value = "/deleteById",method = RequestMethod.GET)
//    public ObjectRestResponse deleteById (Integer id){
//        baseBiz.deleteByIdstute(id);
//        return ObjectRestResponse.succ();
//    }

        @ApiOperation("上下架")
    @GetMapping("/deleteById")
    public ObjectRestResponse deleteInoPortAnalyse(Long id ,Integer status) {
        RscpImageDataTotal areaInfo = new RscpImageDataTotal();
        areaInfo.setId(id);
        areaInfo.setStatus(status);
        baseBiz.updateSelectiveById(areaInfo);
        return ObjectRestResponse.succ();
    }




}