package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpMonitorimageBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpMosaicimageBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataNewest;
import com.upyuns.platform.rs.datacenter.entity.RscpMonitorimage;
import com.upyuns.platform.rs.datacenter.entity.RscpMosaicimage;
import com.upyuns.platform.rs.datacenter.pojo.RscpImageDataNewestDTO;
import com.upyuns.platform.rs.datacenter.utils.GeoServerUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@RestController
@RequestMapping("/web/rscpMonitorimage")
public class RscpMonitorimageController extends BaseController<RscpMonitorimageBiz, RscpMonitorimage> {

    @RequestMapping(value = "/app/unauth/publishMap",method={RequestMethod.POST})
    @ResponseBody
    @IgnoreUserToken
    public ObjectRestResponse<String> publishMap(@RequestBody PublishMapDTO dto){
//        if(StrUtil.isBlank(dto.getWorkSpace())) {
            dto.setWorkSpace("gdxm");
//        }
//        ResultBean<String> resultBean = new ResultBean<String>();
        dto.setStyle("raster");
        GeoServerUtil.publishGeoTIFF(dto.getWorkSpace(), dto.getLayerName(), dto.getFilePath(), dto.getLayerName(), dto.getStyle());
//		HttpClientUtils httpClientApi = new HttpClientUtils("https://zzrsmgmt.upyuns.com/api/website/lmyxmonitorimage/web/app/unauth/baseAdd");
//		httpClientApi.execute()
        RscpMonitorimage rscpMonitorimage = new RscpMonitorimage();
        rscpMonitorimage.setStatus(2);
//        rscpMonitorimage.setType(dto.getType());
        if(dto.getType() == 2213) {
            rscpMonitorimage.setLegendurl("https://hstandfarm.upyuns.com/legend/植被覆盖度图例.png");
        }
        if(dto.getType() == 2214) {
            rscpMonitorimage.setLegendurl("https://hstandfarm.upyuns.com/legend/乡镇绿地图例.png");
        }
        if(dto.getType() == 2215) {
            rscpMonitorimage.setLegendurl("https://hstandfarm.upyuns.com/legend/水体识别图例.png");
        }
        if(dto.getType() == 2216) {
            rscpMonitorimage.setLegendurl("https://hstandfarm.upyuns.com/legend/火灾风险等级图例.png");
        }
        if(dto.getType() == 2217) {
            rscpMonitorimage.setLegendurl("https://hstandfarm.upyuns.com/legend/病虫害林地图例.png");
        }
        if(dto.getType() == 2218) {
            rscpMonitorimage.setLegendurl("https://hstandfarm.upyuns.com/legend/植被覆盖变化图例.png ");
        }

        rscpMonitorimage.setUrl("https://hstandfarm.upyuns.com/geoserver/"+dto.getWorkSpace()+"/wms");
        rscpMonitorimage.setTitle(dto.getTitle());
        rscpMonitorimage.setResourcename(dto.getLayerName());
        rscpMonitorimage.setStartTime(DateUtil.offsetDay(DateUtil.date(), -1));
        rscpMonitorimage.setEndTime(DateUtil.date());
        baseBiz.insertSelective(rscpMonitorimage);

        return ObjectRestResponse.succ();
    }

    @Data
    public static class PublishMapDTO {
        String workSpace;
        String title;
        String filePath;
        String layerName;
        String style;
        Integer type;
    }

    @ApiModelProperty("检测图斑最新时间分页")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/mapAll",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpMonitorimage>> getPageList(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpMonitorimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status",2);
        criteria.andEqualTo("isDel",0);
        example.setOrderByClause("start_time DESC");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }




    @ApiModelProperty("检测图斑热度")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/hotall",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpMonitorimage>> all(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpMonitorimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status",2);
        criteria.andEqualTo("isDel",0);
        example.setOrderByClause("hot DESC");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }
    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse unauthQuery() {

        List<RscpMonitorimage> list = baseBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpMonitorimage::getStatus, 2);
            w.andEqualTo(RscpMonitorimage::getIsDel, 0);
            return w;
        }, "hot DESC, start_time DESC");
        return ObjectRestResponse.succ(list);
    }
//
//    @RequestMapping(value = "/app/unauth/mapAll", method = RequestMethod.GET)
//    @IgnoreUserToken
//    public ObjectRestResponse mapAll(RscpImageDataNewestDTO dto) {
//
//        List<RscpMonitorimage> list = baseBiz.selectByWeekend(w -> {
//            w.andEqualTo(RscpMonitorimage::getStatus, 2);
//            return w;
//        }, "hot DESC");
//        PageInfo<RscpMonitorimage> pageInfo = new PageInfo<>(list);
//        PageDataVO pageData = new PageDataVO(pageInfo.getTotal(), pageInfo.getList());
//
//        return ObjectRestResponse.succ(pageData);
//    }
//
//    @Data
//    public class PageDataVO {
//        private long total;
//        private List<RscpMonitorimage> list;
//
//
//        public  PageDataVO(long total, List<RscpMonitorimage> list) {
//            this.total = total;
//            this.list = list;
//        }

//
//    }
}


